<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MenuItemIngredients extends Model 
{

    protected $table = 'menu_item_ingredients';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function ingredient()
    {
        return $this->belongsTo('App\Models\Ingredient');
    }

    public function menu_item()
    {
        return $this->hasOne('App\Models\MenuItem');
    }

}